<?php
// Iniciar sesión
session_start();

// Verificar si el usuario está autenticado
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

// Incluir conexión a la base de datos
require_once 'conexiones/conexion.php';
require_once 'solicitudes/email_usuario_conectado.php';
// Obtener datos del usuario
$role = $result['role']; // 'admin' o 'user'
$email = $result['email'];

// Fecha actual y mes actual
$hoy = date('Y-m-d');
$mes_actual = date('Y-m');

// Estadísticas generales
// Total de tickets vendidos hoy
$stmt = $pdo->prepare("SELECT COUNT(*) AS tickets_hoy FROM tickets WHERE DATE(fecha_creacion) = ? AND usuario_venta = ?");
$stmt->execute([$hoy, $email]);
$tickets_hoy = $stmt->fetch(PDO::FETCH_ASSOC)['tickets_hoy'] ?? 0;

// Total recaudado hoy
$stmt = $pdo->prepare("SELECT SUM(precio) AS recaudado_hoy FROM tickets WHERE DATE(fecha_creacion) = ? AND usuario_venta = ?");
$stmt->execute([$hoy, $email]);
$recaudado_hoy = $stmt->fetch(PDO::FETCH_ASSOC)['recaudado_hoy'] ?? 0;

// Total de tickets vendidos este mes
$stmt = $pdo->prepare("SELECT COUNT(*) AS tickets_mes FROM tickets WHERE DATE_FORMAT(fecha_creacion, '%Y-%m') = ? AND usuario_venta = ?");
$stmt->execute([$mes_actual, $email]);
$tickets_mes = $stmt->fetch(PDO::FETCH_ASSOC)['tickets_mes'] ?? 0;

// Recaudación total este mes
$stmt = $pdo->prepare("SELECT SUM(precio) AS recaudado_mes FROM tickets WHERE DATE_FORMAT(fecha_creacion, '%Y-%m') = ? AND usuario_venta = ?");
$stmt->execute([$mes_actual, $email]);
$recaudado_mes = $stmt->fetch(PDO::FETCH_ASSOC)['recaudado_mes'] ?? 0;

// Si es administrador, obtener estadísticas globales
if ($role === 'admin') {
    // Total de tickets vendidos (global)
    $stmt = $pdo->prepare("SELECT COUNT(*) AS tickets_totales FROM tickets WHERE DATE_FORMAT(fecha_creacion, '%Y-%m') = ?");
    $stmt->execute([$mes_actual]);
    $tickets_totales = $stmt->fetch(PDO::FETCH_ASSOC)['tickets_totales'] ?? 0;

    // Recaudación total (global)
    $stmt = $pdo->prepare("SELECT SUM(precio) AS recaudado_total FROM tickets WHERE DATE_FORMAT(fecha_creacion, '%Y-%m') = ?");
    $stmt->execute([$mes_actual]);
    $recaudado_total = $stmt->fetch(PDO::FETCH_ASSOC)['recaudado_total'] ?? 0;
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estadísticas - Sistema de Tickets</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
          <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>
<body>
	<?php 
include "menuajuste.php";
	 ?>
    <div class="content">
        <h1 class="text-center">Estadísticas</h1>
        <div class="row">
            <!-- Estadísticas generales -->
            <div class="col-md-6">
                <div class="card mb-4">
                    <div class="card-body">
                        <h5 class="card-title">Hoy</h5>
                        <p class="card-text">Tickets vendidos: <strong><?= $tickets_hoy ?></strong></p>
                        <p class="card-text">Recaudación: <strong>$<?= number_format($recaudado_hoy, 2) ?></strong></p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card mb-4">
                    <div class="card-body">
                        <h5 class="card-title">Este Mes</h5>
                        <p class="card-text">Tickets vendidos: <strong><?= $tickets_mes ?></strong></p>
                        <p class="card-text">Recaudación: <strong>$<?= number_format($recaudado_mes, 2) ?></strong></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Estadísticas globales para administradores -->
        <?php if ($role === 'admin'): ?>
            <div class="row">
                <div class="col-md-6">
                    <div class="card mb-4">
                        <div class="card-body">
                            <h5 class="card-title">Global (Este Mes)</h5>
                            <p class="card-text">Tickets vendidos (global): <strong><?= $tickets_totales ?></strong></p>
                            <p class="card-text">Recaudación total (global): <strong>$<?= number_format($recaudado_total, 2) ?></strong></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card mb-4">
                        <div class="card-body">
                            <h5 class="card-title">Mas estadisticas</h5>
                            <p class="card-text">En la proxima actualizacion distarcode.com</p>
                           
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
